
module Evaluation where

open import Library
open import Types
open import Terms
open import Substitutions

-- Plus operator on values
infixl 6 _+ᵥ_
_+ᵥ_ : Val ℕₜ → Val ℕₜ → Val ℕₜ
zeroᵥ +ᵥ n₂ = n₂
sucᵥ n₁ +ᵥ n₂ = sucᵥ (n₁ +ᵥ n₂)

-- Big-step evaluation of closed terms, counting reduction steps.

{-# TERMINATING #-} -- pen and paper proof

evalCountSteps : ∀ {A} → ClTm A → (ℕ × Val A)

evalCountSteps (var ())

evalCountSteps (abort t) with consistency t
evalCountSteps (abort t) | ()

evalCountSteps ⟨⟩ = 0 , ⟨⟩ᵥ

evalCountSteps zero = 0 , zeroᵥ

evalCountSteps (suc t) with evalCountSteps t
... | n , u = n + 1 , sucᵥ u

evalCountSteps (t₁ ⊹ t₂) with evalCountSteps t₁ | evalCountSteps t₂
... | n , u₁ | m , u₂ = n + m + 1 , u₁ +ᵥ u₂

evalCountSteps (ƛ t) = 0 , ƛᵥ t

evalCountSteps (t₁ ∙ t₂) with evalCountSteps t₁
... | n , ƛᵥ u with evalCountSteps (u [ t₂ /x])
... | m , u′ = n + m + 1 , u′

evalCountSteps ⟨ t₁ , t₂ ⟩ = 0 , ⟨ t₁ , t₂ ⟩ᵥ

evalCountSteps (π₁ t) with evalCountSteps t
... | n , ⟨ u₁ , u₂ ⟩ᵥ with evalCountSteps u₁
... | m , u′ = n + m + 1 , u′

evalCountSteps (π₂ t) with evalCountSteps t
... | n , ⟨ u₁ , u₂ ⟩ᵥ with evalCountSteps u₂
... | m , u′ = n + m + 1 , u′

evalCountSteps (in₁ t) = 0 , in₁ᵥ t

evalCountSteps (in₂ t) = 0 , in₂ᵥ t

evalCountSteps (cse t of u₁ , u₂) with evalCountSteps t
... | n , in₁ᵥ t₁ = n + (proj₁ P) + 1 , (proj₂ P)
  where P = evalCountSteps (u₁ [ t₁ /x])
... | n , in₂ᵥ t₂ = n + (proj₁ P) + 1 , (proj₂ P)
  where P = evalCountSteps (u₂ [ t₂ /x])

evalCountSteps (next t) = 0 , nextᵥ t

evalCountSteps (prev t wth u) with evalCountSteps (t [ u /x])
... | n , nextᵥ t₁ with evalCountSteps t₁
... | m , u′ = n + m + 1 , u′

evalCountSteps (box t wth u) = 0 , boxᵥ t wth u

evalCountSteps (unbox t) with evalCountSteps t
... | n , boxᵥ t′ wth u with evalCountSteps (t′ [ u /x])
... | m , u′ = n + m + 1 , u′

evalCountSteps (box+ t wth u) with evalCountSteps (t [ u /x])
... | n , in₁ᵥ t₁ = n , in₁ᵥ (box′ t₁)
... | n , in₂ᵥ t₁ = n , in₂ᵥ (box′ t₁)

evalCountSteps (t₁ ⊛ t₂) with evalCountSteps t₁ | evalCountSteps t₂
... | n , nextᵥ u₁ | m , nextᵥ u₂ = n + m , nextᵥ (u₁ ∙ u₂)

evalCountSteps (fold t) = 0 , foldᵥ t

evalCountSteps (unfold t) with evalCountSteps t
... | n , foldᵥ u with evalCountSteps u
... | m , u′ = n + m + 1 , u′

-- Big-step evaluation

eval : ∀ {A} → ClTm A → Val A
eval = proj₂ ∘ evalCountSteps

-- Length of reduction

reduction-length : ∀ {A} → ClTm A → ℕ
reduction-length = proj₁ ∘ evalCountSteps
