
module Library where

------------------------------------
-- Imports from the standard library

open import Function public

open import Relation.Binary public

open import Relation.Binary.PropositionalEquality
  using (_≡_; refl)
  public

open import Relation.Binary.Vec.Pointwise
  using ([]; _∷_)
  renaming (Pointwise′ to ∼V)
  public

open import Relation.Nullary public

open import Data.Empty using (⊥; ⊥-elim) public

open import Data.Nat
  using (ℕ; zero; suc; z≤n; s≤s; _+_; _∸_)
  renaming (_≤_ to _≤ℕ_; _>_ to _>ℕ_; _≰_ to _≰ℕ_; _<_ to _<ℕ_; _≤?_ to _≤ℕ?_)
  public

open import Data.Fin
  using (Fin)
  renaming (_<_ to _<F_; _≤_ to _≤F_; _+_ to _+F_; toℕ to Ftoℕ;
            inject₁ to injectFin)
  public

open import Data.Fin.Properties public

open import Data.Product
  using (Σ; Σ-syntax; _×_; _,_; _,′_; proj₁; proj₂)
  public

open import Data.Vec
  using (Vec; []; _∷_; _∷ʳ_)
  renaming (_++_ to _++V_)
  public

open import Data.List
  using (List; []; _∷_)
  renaming (_++_ to _++L_)
  public

-- A simpler redefinition of Data.Vec.take.

take : ∀ {a} {A : Set a} m {n} → Vec A (m + n) → Vec A m
take zero xs = []
take (suc m) (x ∷ xs) = x ∷ take m xs

-- Some facts about inequality

pred≤ℕ : ∀{n m} → suc n ≤ℕ suc m → n ≤ℕ m
pred≤ℕ (s≤s p) = p

≰-to-> : {n m : ℕ} → n ≰ℕ m → n >ℕ m
≰-to-> {zero} p = ⊥-elim (p z≤n)
≰-to-> {suc n} {zero} p = s≤s z≤n
≰-to-> {suc n} {suc m} p = s≤s (≰-to-> (λ z → p (s≤s z)))
