module RunningThePrograms where

open import Library
open import Types
open import Terms
open import Evaluation public
open import Examples public

------------------------------------------------------------------------
--- How to evaluate gλ-programs:
--- 
--- Using the eval from Evaluation, one can find normal forms of closed
--- gλ-terms. In practice, this can be done with Agda's C-c C-n feature.
---
--- Example: A program computing the fifth fibonacci number is
---
---     (nth 5) ∙ fib.
---
--- We wish to run the program, so we ask Agda to normalise the result of
--- applying eval to it
---
---     C-c C-n eval ((nth 5) ∙ fib) RET 
---
--- which yields the output
---
---     sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ zeroᵥ)))).
---
--- Luckily, we get the same output by evaluating (nth 5) ∙ fib-ho. If one is
--- curious about which implementation of the fibonaccis is most efficient, one
--- can compare their respective reduction lengths:
---
---     C-c C-n
---      reduction-length ((nth 5) ∙ fib) ,′ reduction-length ((nth 5) ∙ fib-ho)
---      RET
---
---
--- An alternative to using C-c C-n, is to use Agsy, Agda's proof search
--- algorithm. Say we want to evaluate the program
---
---     (nth 4) ∙ zeros.
---
--- We can then write
--- 
--- 4th-zeros : eval ((nth 4) ∙ zeros) ≡ {!!}
--- 4th-zeros = refl
---
--- which will give us a hole where we can use C-c C-a to automatically find a
--- fitting Agda term, which it does by evaluating the left-hand side. Thus we
--- can achieve a proof that this program indeed does evaluate to zeroᵥ.
---
--- A few examples:

0th-paperfolds : eval ((nth 0) ∙ paperfolds) ≡ sucᵥ zeroᵥ
0th-paperfolds = refl

20th-paperfolds : eval ((nth 20) ∙ paperfolds) ≡ sucᵥ zeroᵥ
20th-paperfolds = refl


8th-fib : eval ((nth 8) ∙ fib) ≡
  sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ
  (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ
  (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ (sucᵥ zeroᵥ)))))))))))))))))))) -- AKA 21
8th-fib = refl
